/** @file   warglobals.cpp
 * @brief   Global variable definition file
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "warglobals.h"
#include "player.h"
#include "door.h"
#include "bonusobject.h"
#include "consts.h"

using std::vector;

namespace WeWantWar {


vector<BonusObject*> WarGlobals::bonusList;
vector<Door*> WarGlobals::doorList;
vector<Teleporter*> WarGlobals::teleporterList;

ObjectStorage* WarGlobals::pObjTable = 0;
Hud* WarGlobals::pHud = 0;
Level* WarGlobals::pLevel = 0;
BulletTable* WarGlobals::pBulletManager = 0;
ShadowManager* WarGlobals::pShadowManager = 0;

eng2d::ParticleManager* WarGlobals::pPartManager = 0;
eng2d::LightFenceManager* WarGlobals::pFenceManager = 0;

Statistics WarGlobals::gameStats;

int WarGlobals::numberOfLives = 3;
int WarGlobals::timeBonuses = 1000;

bool WarGlobals::bulletTimeMode = false;
int WarGlobals::bulletTimeLeft = 250;

bool WarGlobals::captureFeatureOn = true;
bool WarGlobals::captureVehicle = false;
bool WarGlobals::freeScrollMode = false;

bool WarGlobals::screenLockMode = false;
eng2d::Vec2D WarGlobals::screenLockPos;


/** Initializes the globals.
 */
void WarGlobals::initGlobals()
{
  pPartManager = new eng2d::ParticleManager();
  pFenceManager = new eng2d::LightFenceManager();
  pHud = new Hud();
  pObjTable = new ObjectStorage();
  pBulletManager = new BulletTable();
  pShadowManager = new ShadowManager();
  
  bulletTimeMode = false;
  bulletTimeLeft = Consts::MAX_BULLETTIME;
  
  screenLockMode = false;
  gameStats.resetLevelStats();
}



/** Cleans up the globals.
 */
void WarGlobals::cleanupGlobals()
{
  
  delete pPartManager;
  pPartManager = 0;
  delete pFenceManager;
  pFenceManager = 0;
  delete pHud;
  pHud = 0;
  delete pObjTable;
  pObjTable = 0;
  delete pBulletManager;
  pBulletManager = 0;
  delete pShadowManager;
  
  // And now we destroy the remaining GameObjects
  WarGlobals::cleanup();
}



/** Prepares the object-lists for new game.
 */
void WarGlobals::prepareObjects()
{
}



/** Cleans up the contents of the object lists.
 */
void WarGlobals::cleanup()
{
  for (int i=0; i < bonusList.size(); i++) {
    if ( bonusList.at(i) != 0 ) {
      delete bonusList.at(i);
      bonusList.at(i) = 0;
    }
  }
  bonusList.clear();
  
  for (int i=0; i < doorList.size(); i++) {
    if ( doorList.at(i) != 0 ) {
      delete doorList.at(i);
      doorList.at(i) = 0;
    }
  }
  doorList.clear();
  
  for ( int i=0; i < teleporterList.size(); i++ ) {
    if ( teleporterList.at(i) != 0 ) {
      delete teleporterList.at(i);
    }
  }
  teleporterList.clear();
}



/** Increases the bullettime
 */
void WarGlobals::increaseBulletTime( int amount )
{
  bulletTimeLeft += amount;
  if ( bulletTimeLeft > Consts::MAX_BULLETTIME ) {
    bulletTimeLeft = Consts::MAX_BULLETTIME;
  }
}


/** Adds the given bonusitem to the bonus-list
 */
void WarGlobals::addBonusObject( BonusObject* pB )
{
  bonusList.push_back( pB );
}


}   // end of namespace

/**
 * Version history
 * ===============
 * $Log: warglobals.cpp,v $
 * Revision 1.1.1.1  2006/01/21 23:02:43  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:07+02  lamminsa
 * Initial revision
 *
 */
